package org.openliberty.xmltooling.dst2_1;

import net.shibboleth.utilities.java.support.xml.ElementSupport;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.w3c.dom.Element;

/**
 * This marshaller can be used by any of the elements that extend 
 * DSTString without adding new atts or any elements.
 * 
 * @author asa
 *
 */
public class DSTStringMarshaller extends AbstractXMLObjectMarshaller
{

    @Override
    protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
    {
        DSTString dSTString = (DSTString)xmlObject;
        dSTString.attributes().marshallAttributes(domElement);
    }

    @Override
    protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
    {
        DSTString dSTString = (DSTString) xmlObject;
        ElementSupport.appendTextContent(domElement, dSTString.getValue());
    }

    
    
}


