package org.openliberty.xmltooling.dst2_1;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

/**
 * This is the default Unmarshaller for classes that extend DSTString
 * 
 * @author asa
 *
 */
public class DSTStringUnmarshaller extends AbstractXMLObjectUnmarshaller
{

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        DSTString dSTString = (DSTString) xmlObject;
        dSTString.setValue(elementContent);
    }

    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        DSTString dSTString = (DSTString) xmlObject;
        dSTString.attributes().processAttribute(attribute, dSTString);
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        // There are no child elements 
    }

}
