package org.openliberty.xmltooling.dst2_1;

import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSURI;

public class DSTURI extends AbstractXMLObject implements XSURI
{

    private LeafAttributes attributes;
    private String value;               // xs:anyURI

    
    public DSTURI(String elementLocalName, String value)
    {
        super(Konstantz.DST_NS, elementLocalName, Konstantz.DST_PREFIX);
        this.setValue(value);
        attributes = new LeafAttributes();      
    }
    
    public DSTURI(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);     
        attributes = new LeafAttributes();      
    }

    public LeafAttributes attributes()
    {
        return attributes;
    }
    
    public static boolean isValid(DSTURI dSTURI)
    {
        if(null!=dSTURI)
        {
            String uri = dSTURI.getValue();
            if(null==uri || uri.trim().length()==0) return false;                
        }
        
        return true;
    }
    
    public boolean isValid()
    {
        return isValid(this);
    }

    public void setValue(String value) 
    {
        // TODO: enforce URI type??
        this.value = prepareForAssignment(this.value, value);
    }

    public String getValue() 
    { 
        return value; 
    }

    // no child elements
    public List<XMLObject> getOrderedChildren() 
    {
        return null;
    }

    
    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DSTURI>
    {
        @Override
        public DSTURI buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new DSTURI(namespaceURI, localName, namespacePrefix);
        }        
    }

    
}
