package org.openliberty.xmltooling.dst2_1;

import org.joda.time.DateTime;
import org.openliberty.xmltooling.utility_2_0.ResponseType;

public abstract class DataResponseBaseType extends ResponseType
{
    
    // Attribute Name
    public static final String ATT_TIME_STAMP = "timeStamp";
    
    // Attribute
    private DateTime timeStamp;
    
    protected DataResponseBaseType(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public DateTime getTimeStamp()
    {
        return timeStamp;
    }
    
    public void setTimeStamp(DateTime timeStamp)
    {
        this.timeStamp = prepareForAssignment(this.timeStamp, timeStamp);
    }
    
    
}

/*
<xs:complexType name="DataResponseBaseType">
<xs:complexContent>
  <xs:extension base="lu:ResponseType">
    <xs:attribute name="timeStamp" use="optional" type="xs:dateTime"/>
  </xs:extension>
</xs:complexContent>
</xs:complexType>
*/