package org.openliberty.xmltooling.dst2_1;

import org.joda.time.DateTime;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * 
 * <pre>
 *   &lt;xs:complexType name="DeleteItemBaseType"&gt;
 *     &lt;xs:attributeGroup ref="dst:selectQualif"/&gt;
 *     &lt;xs:attribute name="notChangedSince" use="optional" type="xs:dateTime"/&gt;
 *     &lt;xs:attribute name="id" use="optional" type="xs:ID"/&gt;
 *     &lt;xs:attribute ref="lu:itemID" use="optional"/&gt;
 *   &lt;/xs:complexType&gt;
 *   </pre>
 * @author asa
 *
 */
public abstract class DeleteItemBaseType extends AbstractSignableXMLObject
{
    
    // Attributes
    private SelectQualifAttributes selectQualifAttributes;  // 
    private DateTime notChangedSince;                       // xs:dateTime
    private String id;                                      // xs:ID
    private String itemID;                                  // lu:itemID

    // Attribute Names
    public static String ATT_ID = "id";
    public static String ATT_ITEM_ID = "itemID";
    public static String ATT_NOT_CHANGED_SINCE = "notChangedSince";
    
    protected DeleteItemBaseType(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        selectQualifAttributes = new SelectQualifAttributes();
    }

    public SelectQualifAttributes getSelectQualifAttributes()
    {
        return selectQualifAttributes;
    }
    
    public void setNotChangedSince(DateTime notChangedSince)
    {
       this.notChangedSince = prepareForAssignment(this.notChangedSince, notChangedSince);
    }
    
    public DateTime getNotChangedSince()
    {
       return notChangedSince;    
    }
    
    public void setId(String id)
    {
        this.id = prepareForAssignment(this.id, id);
    }

    public String getId()
    {
        return id;        
    }
    
    public void setItemID(String itemID)
    {
        this.itemID = prepareForAssignment(this.itemID, itemID);
    }

    public String getItemID()
    {
        return itemID;        
    }

    /**
     * This is the internal marshaller for the DeleteItemBaseType
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            DeleteItemBaseType obj = (DeleteItemBaseType)xmlObject;
            
            // Marshall the contents of the SelectQualifAttributes object into the DOM
            obj.selectQualifAttributes.marshallAttributes(domElement);
            
            if(obj.getId()!=null) 
            {
                domElement.setAttributeNS(null, DeleteItemBaseType.ATT_ID, obj.getId());
            }

            if(obj.getItemID()!=null) 
            {
                domElement.setAttributeNS(null, DeleteItemBaseType.ATT_ITEM_ID, obj.getItemID());
            }

            if(obj.getNotChangedSince()!=null) 
            {
                domElement.setAttributeNS(null, DeleteItemBaseType.ATT_NOT_CHANGED_SINCE, OpenLibertyHelpers.stringForDateTime(obj.getNotChangedSince()));
            }

            
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no element content
        }

    }
    
    
    /**
     * Internal unmarshaller, placing attribute DOM values into the DeleteItemBaseType object
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            DeleteItemBaseType obj = (DeleteItemBaseType)xmlObject;
            
            if(!obj.selectQualifAttributes.processAttribute(attribute, obj))
            {
                if (attribute.getLocalName().equals(DeleteItemBaseType.ATT_ID)) 
                {            
                    obj.setId(attribute.getValue());
                }
                else if (attribute.getLocalName().equals(DeleteItemBaseType.ATT_ITEM_ID)) 
                {            
                    obj.setItemID(attribute.getValue());
                }
                else if (attribute.getLocalName().equals(DeleteItemBaseType.ATT_NOT_CHANGED_SINCE)) 
                {            
                    obj.setNotChangedSince(OpenLibertyHelpers.dateTimeForString(attribute.getValue()));
                }
            }            
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            // this base type has no children
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            // this base type has no element content
        }
        
    }
    
    
}
