package org.openliberty.xmltooling.dst2_1;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.AbstractXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ItemDataAttributeGroup
{

    public static final String ITEM_ID_REF = "itemIDRef";
    public static final String NOT_SORTED = "notSorted";
    public static final String CHANGE_FORMAT = "changeFormat";

    private String itemIDRef;
    private NotSorted notSorted;
    private ChangeFormat.ChangeFormatAttribute changeFormat;    

    
    
    /**
     * This is a convenience method used by any Marshaller that is marshalling 
     * an object that has ItemDataAttributeGroup
     *
     */
    public void marshallAttributes(Element domElement)
    {
        
        if(itemIDRef!=null) 
        {
            domElement.setAttributeNS(null, ITEM_ID_REF, itemIDRef);
            //domElement.setIdAttributeNS(null, ITEM_ID_REF, true);
        }

        if(notSorted!=null)
        {
            domElement.setAttributeNS(null, NOT_SORTED, notSorted.value());
        }

        if(changeFormat!=null)
        {
            domElement.setAttributeNS(null, CHANGE_FORMAT, changeFormat.value());
        }

    }

    /**
     * This method assists the unmarshaller, adding an XML Attribute to 
     * the ItemDataAttributeGroup object
     *     
     * @param attribute the attribute to set
     * 
     * @return whether an attribute was found and set
     */
    public boolean processAttribute(Attr attribute, AbstractXMLObject abstractXMLObject)
    {

        if (attribute.getLocalName().equals(ITEM_ID_REF)) 
        {
            this.setItemIDRef(attribute.getValue(), abstractXMLObject);
            // attribute.getOwnerElement().setIdAttributeNode(attribute, true);
            return true;
        }
        else if (attribute.getLocalName().equals(NOT_SORTED)) 
        {            
            this.setNotSorted(NotSorted.forValue(attribute.getValue()), abstractXMLObject);
            return true;
        }
        else if (attribute.getLocalName().equals(CHANGE_FORMAT)) 
        {            
            this.setChangeFormat(ChangeFormat.ChangeFormatAttribute.forValue(attribute.getValue()), abstractXMLObject);
            return true;
        }
        
        return false;

    }
    

    
    
    
    
    
    
    public void setItemIDRef(String itemIDRef, AbstractXMLObject abstractXMLobject)
    {
        this.itemIDRef = OpenLibertyHelpers.prepareForAssignment(this.itemIDRef, itemIDRef, abstractXMLobject);
    }

    public String getItemIDRef()
    {
        return this.itemIDRef;
    }

    public void setNotSorted(NotSorted notSorted, AbstractXMLObject abstractXMLobject)
    {
        this.notSorted = OpenLibertyHelpers.prepareForAssignment(this.notSorted, notSorted, abstractXMLobject);
    }
    
    public NotSorted getNotSorted()
    {
        return notSorted;
    }
    
    public void setChangeFormat(ChangeFormat.ChangeFormatAttribute changeFormat, AbstractXMLObject abstractXMLobject)
    {
        this.changeFormat = OpenLibertyHelpers.prepareForAssignment(this.changeFormat, changeFormat, abstractXMLobject);
    }
    
    public ChangeFormat.ChangeFormatAttribute getChangeFormat()
    {
        return changeFormat;
    }
    
    
    public enum NotSorted
    {
        NOW("Now"), NEVER("Never"), EMPTY(null);
        
        private String value;
        
        private NotSorted(String value)
        {
            this.value = value;
        }
        
        public static NotSorted forValue(String value)
        {
            if(value!=null)
            {
                if(NOW.value().equals(value)) return NOW;
                else if(NEVER.value().equals(value)) return NEVER;
            }
            // else
            return EMPTY;
        }
        
        public String value() { return value; }
        
    }
    
}

/*
<xs:attributeGroup name="ItemDataAttributeGroup">
<xs:attribute ref="lu:itemIDRef" use="optional"/>
<xs:attribute name="notSorted" use="optional">
  <xs:simpleType>
    <xs:restriction base="xs:string">
      <xs:enumeration value="Now"/>
      <xs:enumeration value="Never"/>
    </xs:restriction>
  </xs:simpleType>
</xs:attribute>
<xs:attribute ref="dst:changeFormat" use="optional"/>
</xs:attributeGroup>
*/