package org.openliberty.xmltooling.dst2_1;

import org.joda.time.DateTime;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.AbstractXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class LeafAttributes extends CommonAttributes
{
	
	
    public static String ACC_TIME = "ACCTime";
    public static String ACC = "ACC";
    public static String MODIFIER = "modifier";

    private String aCC;
    private DateTime aCCTime;
    private String modifier;

    /**
     * This is a convenience method used by any Marshaller that is marshalling 
     * an object that has LeafAttributes
     *
     */
    @Override
	public void marshallAttributes(Element domElement)
    {
        // Marshall id and ACCTime
        super.marshallAttributes(domElement);

        if(aCCTime!=null)
        {
            domElement.setAttributeNS(null, ACC_TIME, OpenLibertyHelpers.stringForDateTime(aCCTime));
        }

        if(aCC!=null) 
        {
            domElement.setAttributeNS(null, ACC, aCC);
        }

        if(modifier!=null) 
        {
            domElement.setAttributeNS(null, MODIFIER, modifier);
        }
    }

    /**
     * This method assists the unmarshaller, adding an XML Attribute to 
     * the LeafAttributes object
     * 
     *     
     * @param attribute the attribute to set
     * 
     * @return whether an attribute was found and set
     */
    @Override
	public boolean processAttribute(Attr attribute, AbstractXMLObject abstractXMLObject)
    {
        if(super.processAttribute(attribute, abstractXMLObject))
        {
            return true;
        }
        else if (attribute.getLocalName().equals(ACC_TIME)) 
        {
            this.setACCTime(OpenLibertyHelpers.dateTimeForString(attribute.getValue()), abstractXMLObject);
            return true;
        }
        else if (attribute.getLocalName().equals(ACC)) 
        {            
            this.setACC(attribute.getValue(), abstractXMLObject);
            return true;
        }  
        else if (attribute.getLocalName().equals(MODIFIER)) 
        {            
            this.setModifier(attribute.getValue(), abstractXMLObject);
            return true;
        } 
        
        return false;
    }


    /**
     * 
     * @return xs:anyURI
     */
    public String getACC()
    {
        return this.aCC;
    }
    /**
     * 
     * @param acc xs:anyURI
     */
    public void setACC(String aCC, AbstractXMLObject abstractXMLObject)
    
    {
        this.aCC = OpenLibertyHelpers.prepareForAssignment(this.aCC, aCC, abstractXMLObject);
    }
    /**
     * 
     * @return xs:dateTime
     */
    public DateTime getACCTime()
    {
        return aCCTime;
    }
    /**
     * 
     * @param aCCTime xs:dateTime
     */
    public void setACCTime(DateTime aCCTime, AbstractXMLObject abstractXMLObject)
    {
        this.aCCTime = OpenLibertyHelpers.prepareForAssignment(this.aCCTime, aCCTime, OpenLibertyHelpers.getDefaultDateFormatter(), abstractXMLObject);		
    }
    /**
     * 
     * @return md:entityIDType xs:anyURI maxlength 1024
     */	
    public String getModifier()
    {
        return this.modifier;
    }
    /**
     * 
     * @param modifier md:entityIDType xs:anyURI maxlength 1024
     */
    public void setModifier(String modifier, AbstractXMLObject abstractXMLObject)
    {
        // TODO: should we prevent a value larger than 1024 from being set?  How is this generally handled by other implementations?
        this.modifier = OpenLibertyHelpers.prepareForAssignment(this.modifier, modifier, abstractXMLObject);

    }


}
