package org.openliberty.xmltooling.dst2_1;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.AbstractXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class LocalizedLeafAttributes extends LeafAttributes
{

    public static String LANG = "lang";
    public static String SCRIPT = "script";
    
	private String lang; 	// xml:lang
	private String script; 	// xs:anyURI
	
    
    
    /**
     * This is a convenience method used by any Marshaller that is marshalling 
     * an object that has LocalizedLeafAttributes
     *
     */
    @Override
	public void marshallAttributes(Element domElement)
    {
        // Marshall id, modificationTime, ACCTime, ACC, and modifier
        super.marshallAttributes(domElement);

        if(script!=null)
        {
            domElement.setAttributeNS(null, SCRIPT, script);
        }

        if(lang!=null) 
        {
            domElement.setAttributeNS(null, LANG, lang);
        }

    }

    /**
     * This method assists the unmarshaller, adding an XML Attribute to 
     * the LocalizedLeafAttributes object
     * 
     *     
     * @param attribute the attribute to set
     * 
     * @return whether an attribute was found and set
     */
    @Override
	public boolean processAttribute(Attr attribute, AbstractXMLObject abstractXMLObject)
    {
        if(super.processAttribute(attribute, abstractXMLObject))
        {
            return true;
        }
        else if (attribute.getLocalName().equals(SCRIPT)) 
        {
            this.setScript(attribute.getValue(), abstractXMLObject);
            return true;
        }
        else if (attribute.getLocalName().equals(LANG)) 
        {            
            this.setXMLLang(attribute.getValue(), abstractXMLObject);
            return true;
        }  
        
        return false;
    }

    
    
    
	/**
	 * 
	 * @return xml:lang
	 */
	public String getXMLLang()
	{
		return this.lang;
	}
	/**
	 * 
	 * @param lang xml:lang
	 */
	public void setXMLLang(String lang, AbstractXMLObject abstractXMLObject)
	{
		this.lang = OpenLibertyHelpers.prepareForAssignment(this.lang, lang, abstractXMLObject);
	}
	/**
	 * 
	 * @return xs:anyURI
	 */
	public String getScript()
	{
		return this.script;
	}
	/**
	 * 
	 * @param script xs:anyURI
	 */
	public void setScript(String script, AbstractXMLObject abstractXMLObject)
	{
		this.script = OpenLibertyHelpers.prepareForAssignment(this.script, script, abstractXMLObject);
	}	
}
