package org.openliberty.xmltooling.dst2_1;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.AbstractXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class PaginationAttributeGroup
{

    public static String COUNT = "count";
    public static String OFFSET = "offset";
    public static String SET_ID = "setID";
    public static String SET_REQ = "setReq";

    private Integer count;  // <xs:attribute name="count" use="optional" type="xs:nonNegativeInteger"/>
    private Integer offset; // <xs:attribute name="offset" use="optional" type="xs:nonNegativeInteger" default="0"/>
    private String setID;   // <xs:attribute name="setID" use="optional" type="lu:IDType"/>
    private SetReq setReq;  // <xs:attribute name="setReq" use="optional"/>  "Static" or "DeleteSet" are the enumerations



    /**
     * This is a convenience method used by any Marshaller that is marshalling 
     * an object that has PaginationAttributeGroup
     *
     */
    public void marshallAttributes(Element domElement)
    {

        if(count!=null) 
        {
            domElement.setAttributeNS(null, COUNT, count.toString());
        }

        if(offset!=null)
        {
            domElement.setAttributeNS(null, OFFSET, offset.toString());
        }

        if(setID!=null)
        {
            domElement.setAttributeNS(null, SET_ID, setID);
        }

        if(setReq!=null)
        {
            domElement.setAttributeNS(null, SET_REQ, setReq.value());
        }

    }

    /**
     * This method assists the unmarshaller, adding an XML Attribute to 
     * the PaginationAttributeGroup object
     *     
     * @param attribute the attribute to set
     * 
     * @return whether an attribute was found and set
     */
    public boolean processAttribute(Attr attribute, AbstractXMLObject abstractXMLObject)
    {

        if (attribute.getLocalName().equals(COUNT)) 
        {            
            this.setCount(OpenLibertyHelpers.integerFromString(attribute.getValue()), abstractXMLObject);
        }
        else if (attribute.getLocalName().equals(OFFSET)) 
        {            
            this.setOffset(OpenLibertyHelpers.integerFromString(attribute.getValue()), abstractXMLObject);
        }
        else if (attribute.getLocalName().equals(SET_ID)) 
        {            
            this.setSetID(attribute.getValue(), abstractXMLObject);
        }
        else if (attribute.getLocalName().equals(SET_REQ)) 
        {            
            this.setSetReq(SetReq.forValue( attribute.getValue() ), abstractXMLObject);
        }
        // Attribute Not Found
        else
        {
            return false;
        }

        // Attribute Found
        return true;

    }



    public Integer getCount()
    {
        return count;
    }

    public void setCount(Integer count, AbstractXMLObject abstractXMLobject)
    {
        // TODO: should this fail if the count argument is not a nonNegativeInteger
        this.count = OpenLibertyHelpers.prepareForAssignment(this.count, count, abstractXMLobject);
    }

    public Integer getOffset()
    {
        return offset;
    }

    public void setOffset(Integer offset, AbstractXMLObject abstractXMLobject)
    {
        // TODO: should this fail if the offset argument is not a nonNegativeInteger
        this.offset = OpenLibertyHelpers.prepareForAssignment(this.offset, offset, abstractXMLobject);
    }

    public void setSetID(String setID, AbstractXMLObject abstractXMLobject)
    {
        this.setID = OpenLibertyHelpers.prepareForAssignment(this.setID, setID, abstractXMLobject);
    }

    public String getSetID()
    {
        return setID;
    }

    //SetReq.forValue(setReqStr)
    public void setSetReq(SetReq setReq, AbstractXMLObject abstractXMLobject)
    {
        this.setReq = OpenLibertyHelpers.prepareForAssignment(this.setReq, setReq, abstractXMLobject);
    }

    public SetReq getSetReq()
    {
        return setReq;
    }


    public enum SetReq
    {
        STATIC("Static"), DELETE_SET("DeleteSet"), EMPTY(null);        

        private String value;

        SetReq(String value)
        {
            this.value = value;
        }

        public static SetReq forValue(String value)
        {
            if(value!=null)
            {
                if(STATIC.value().equals(value)) return STATIC;
                else if(DELETE_SET.value().equals(value)) return DELETE_SET;
            }
            // else
            return EMPTY;
        }

        public String value() { return value; }

    }


}
/*

  <xs:attributeGroup name="PaginationAttributeGroup">
    <xs:attribute name="count" use="optional" type="xs:nonNegativeInteger"/>
    <xs:attribute name="offset" use="optional" type="xs:nonNegativeInteger" default="0"/>
    <xs:attribute name="setID" use="optional" type="lu:IDType"/>
    <xs:attribute name="setReq" use="optional">
      <xs:simpleType>
        <xs:restriction base="xs:string">
          <xs:enumeration value="Static"/>
          <xs:enumeration value="DeleteSet"/>
        </xs:restriction>
      </xs:simpleType>
    </xs:attribute>
  </xs:attributeGroup>
 */