package org.openliberty.xmltooling.dst2_1;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.AbstractXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class PaginationResponseAttributeGroup
{

    public static String REMAINING = "remaining";
    public static String NEXT_OFFSET = "nextOffset";
    public static String SET_ID = "setID";
    
    private Integer remaining;
    private Integer nextOffset; // <xs:attribute name="nextOffset" use="optional" type="xs:nonNegativeInteger" default="0"/>
    private String setID;       // <xs:attribute name="setID" use="optional" type="lu:IDType"/>
    

    /**
     * This is a convenience method used by any Marshaller that is marshalling 
     * an object that has PaginationAttributeGroup
     *
     */
    public void marshallAttributes(Element domElement)
    {

        if(remaining!=null) 
        {
            domElement.setAttributeNS(null, REMAINING, remaining.toString());
        }

        if(nextOffset!=null)
        {
            domElement.setAttributeNS(null, NEXT_OFFSET, nextOffset.toString());
        }

        if(setID!=null)
        {
            domElement.setAttributeNS(null, SET_ID, setID);
        }

    }

    /**
     * This method assists the unmarshaller, adding an XML Attribute to 
     * the PaginationAttributeGroup object
     *     
     * @param attribute the attribute to set
     * 
     * @return whether an attribute was found and set
     */
    public boolean processAttribute(Attr attribute, AbstractXMLObject abstractXMLObject)
    {

        if (attribute.getLocalName().equals(REMAINING)) 
        {            
            this.setRemaining(OpenLibertyHelpers.integerFromString(attribute.getValue()), abstractXMLObject);
        }
        else if (attribute.getLocalName().equals(NEXT_OFFSET)) 
        {            
            this.setNextOffset(OpenLibertyHelpers.integerFromString(attribute.getValue()), abstractXMLObject);
        }
        else if (attribute.getLocalName().equals(SET_ID)) 
        {            
            this.setSetID(attribute.getValue(), abstractXMLObject);
        }
        // Attribute Not Found
        else
        {
            return false;
        }

        // Attribute Found
        return true;

    }

    
    public Integer getRemaining()
    {
        return remaining;
    }
    
    public void setRemaining(Integer count, AbstractXMLObject abstractXMLobject)
    {
        this.remaining = OpenLibertyHelpers.prepareForAssignment(this.remaining, remaining, abstractXMLobject);
    }

    public Integer getNextOffset()
    {
        return nextOffset;
    }
    
    public void setNextOffset(Integer nextOffset, AbstractXMLObject abstractXMLobject)
    {
        // TODO: should this fail if the offset argument is not a nonNegativeInteger, maybe set to 0 ?
        this.nextOffset = OpenLibertyHelpers.prepareForAssignment(this.nextOffset, nextOffset, abstractXMLobject);
    }

    public void setSetID(String setID, AbstractXMLObject abstractXMLobject)
    {
        this.setID = OpenLibertyHelpers.prepareForAssignment(this.setID, setID, abstractXMLobject);
    }
    
    public String getSetID()
    {
        return setID;
    }
 
    
    
}
/*

  <xs:attributeGroup name="PaginationResponseAttributeGroup">
    <xs:attribute name="remaining" use="optional" type="xs:integer"/>
    <xs:attribute name="nextOffset" use="optional" type="xs:nonNegativeInteger" default="0"/>
    <xs:attribute name="setID" use="optional" type="lu:IDType"/>
  </xs:attributeGroup>
  
*/