package org.openliberty.xmltooling.dst2_1;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * Base class for requests 
 * 
 * @author asa
 *
 */
public abstract class RequestType extends AbstractXMLObject implements AttributeExtensibleXMLObject
{    
    public static final String ATT_ITEM_ID = "itemID";
    
    // Attributes
    private String itemID;                  // optional
    private AttributeMap otherAttributes;   
    
    // Elements
    private XMLObjectChildrenList<Extension> extensions;  // lu:Extension
    
    protected RequestType(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        otherAttributes = new AttributeMap(this);
    }

    /**
     * Used to provide IDs to components that have IDs that may not be scoped
     * within the local xml instance document.
     * 
     * @return lu:itemID 
     */
    public String getItemID()
    {
     return itemID;   
    }
    
    /**
     * Used to provide IDs to components that have IDs that may not be scoped
     * within the local xml instance document.
     * 
     * @param itemID
     */
    public void setItemID(String itemID)
    {
        this.itemID = prepareForAssignment(this.itemID, itemID);
    }    
    
    /**
     * 
     * @return a list of lu:Extension elements
     */
    public XMLObjectChildrenList<Extension> getExtensions()
    {
        if(null==extensions) extensions = new XMLObjectChildrenList<Extension>(this);
        return extensions;
    }
    
    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        if(null!=extensions) children.addAll(extensions); 
        return Collections.unmodifiableList(children);
    }
    
    /**
     * Implementation of AttributeExtensibleXMLObject interface
     */
    public AttributeMap getUnknownAttributes()
    {
        return otherAttributes;
    }


    /**
     * Marshall attributes into the DOM
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            RequestType obj = (RequestType)xmlObject;
            
            if(obj.getItemID() != null) 
            {
                domElement.setAttributeNS(null, RequestType.ATT_ITEM_ID, obj.getItemID());
            } 
            
            // marshall the unknown attributes (supported by RequestType)
            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }
        
        }

        
        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            // no element content
        }        
    }
    
    
    /**
     * Internal class that handles unmarshalling from the DOM
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {       

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {            
            RequestType obj = (RequestType) parentXMLObject;

            if(childXMLObject instanceof Extension)
            {
                obj.getExtensions().add((Extension)childXMLObject);                   
            }
        }

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            RequestType obj = (RequestType) xmlObject;
            
            if (attribute.getLocalName().equals(RequestType.ATT_ITEM_ID)) 
            {
                obj.setItemID(attribute.getValue());
            } 
            // xs:anyAttribute
            else 
            {
                QName attribQName = QNameSupport.getNodeQName(attribute);
                if (attribute.isId()) 
                {
                    obj.getUnknownAttributes().registerID(attribQName);
                }
                obj.getUnknownAttributes().put(attribQName, attribute.getValue());
            }                           
        }

        
        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            // no element content            
        }

    }
    
    
    
    
    
    
}
