package org.openliberty.xmltooling.dst2_1;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.joda.time.DateTime;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * 
 * <pre>
 *   &lt;xs:complexType name="ResultQueryBaseType"&gt;
 *     &lt;xs:sequence&gt;
 *       &lt;xs:element ref="dst:ChangeFormat"  minOccurs="0" maxOccurs="2"/&gt;
 *     &lt;/xs:sequence&gt;
 *     &lt;xs:attributeGroup ref="dst:selectQualif"/&gt;
 *     &lt;xs:attribute ref="lu:itemIDRef" use="optional"/&gt;
 *     &lt;xs:attribute name="contingency" use="optional" type="xs:boolean"/&gt;
 *     &lt;xs:attribute name="includeCommonAttributes" use="optional" type="xs:boolean" default="0"/&gt;
 *     &lt;xs:attribute name="changedSince" use="optional" type="xs:dateTime"/&gt;
 *     &lt;xs:attribute ref="lu:itemID" use="optional"/&gt;
 *   &lt;/xs:complexType&gt;
 * </pre>
 * 
 * @author asa
 *
 */
public abstract class ResultQueryBaseType extends AbstractSignableXMLObject
{
    // Atributes    
    private Boolean includeCommonAttributes;
    private Boolean contingency;
    private String itemIDRef;
    private DateTime changedSince;
    private String itemID;    
    private SelectQualifAttributes selectQualifAttributes;

    // Attribute Names
    public static String ATT_INCLUDE_COMMON_ATTS = "includeCommonAttributes";
    public static String ATT_CONTINGENCY = "contingency";
    public static String ATT_ITEM_ID_REF = "itemIDRef";         // lu:itemIDRef
    public static String ATT_CHANGED_SINCE = "changedSince";    
    public static String ATT_ITEM_ID = "itemID";                // lu:itemID

    // Elements
    private ChangeFormat changeFormat1; 
    private ChangeFormat changeFormat2; 



    protected ResultQueryBaseType(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        selectQualifAttributes = new SelectQualifAttributes();
    }


    /**
     * Minimum 0 and Maximum 2 ChangeFormat elements
     * 
     * @return
     */
    public ChangeFormat getChangeFormat1()
    {
        return changeFormat1;
    }

    public void setChangeFormat1(ChangeFormat changeFormat)
    {
        this.changeFormat1 = prepareForAssignment(this.changeFormat1, changeFormat);
    }

    public ChangeFormat getChangeFormat2()
    {
        return changeFormat2;
    }

    public void setChangeFormat2(ChangeFormat changeFormat)
    {
        this.changeFormat2 = prepareForAssignment(this.changeFormat2, changeFormat);
    }

    public SelectQualifAttributes getSelectQualifAttributes()
    {
        return selectQualifAttributes;
    }

    /**
     * lu:itemIDRef
     * 
     * @return
     */
    public String getItemIDRef()
    {
        return itemIDRef;
    }
    public void setItemIDRef(String itemIDRef)
    {
        this.itemIDRef = prepareForAssignment(this.itemIDRef, itemIDRef);
    }

    /**
     * Optional boolean attribute with a default value of 0 (false)
     * 
     * @return xs:boolean
     */
    public Boolean getIncludeCommonAttributes()
    {
        return includeCommonAttributes;
    }

    public void setIncludeCommonAttributes(Boolean includeCommonAttributes)
    {
        this.includeCommonAttributes = prepareForAssignment(this.includeCommonAttributes, includeCommonAttributes);
    }

    public Boolean getContingency()
    {
        return contingency;
    }
    public void setContingency(Boolean contingency)
    {
        this.contingency = prepareForAssignment(this.contingency, contingency);
    }

    public DateTime getChangedSince()
    {
        return changedSince;
    }
    public void setChangedSince(DateTime changedSince)
    {
        this.changedSince = prepareForAssignment(this.changedSince, changedSince);
    }

    public String getItemID()
    {
        return itemID;
    }
    public void setItemID(String itemID)
    {
        this.itemID = prepareForAssignment(this.itemID, itemID);
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();        

        if(null!=changeFormat1) children.add(changeFormat1);
        if(null!=changeFormat2) children.add(changeFormat2);

        return Collections.unmodifiableList(children);
    }


    /**
     * Internal class that supports OpenSAML xmltooling marshalling, placing values 
     * from the XMLObject and their class variables into the DOM
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            ResultQueryBaseType obj = (ResultQueryBaseType)xmlObject;

            if(null!=obj.getChangedSince())
            {
                domElement.setAttributeNS(null, ResultQueryBaseType.ATT_CHANGED_SINCE, OpenLibertyHelpers.stringForDateTime(obj.getChangedSince()));
            }

            if(null!=obj.getContingency())
            {
                domElement.setAttributeNS(null, ResultQueryBaseType.ATT_CONTINGENCY, OpenLibertyHelpers.stringFromBoolean(obj.getContingency(), OpenLibertyHelpers.FALSE_STR));
            }

            if(null!=obj.getIncludeCommonAttributes())
            {
                domElement.setAttributeNS(null, ResultQueryBaseType.ATT_INCLUDE_COMMON_ATTS, OpenLibertyHelpers.stringFromBoolean(obj.getIncludeCommonAttributes(), OpenLibertyHelpers.FALSE_STR));
            }

            if(null!=obj.getItemID())
            {
                domElement.setAttributeNS(null, ResultQueryBaseType.ATT_ITEM_ID, obj.getItemID());
            }

            if(null!=obj.getItemIDRef())
            {
                domElement.setAttributeNS(null, ResultQueryBaseType.ATT_ITEM_ID_REF, obj.getItemIDRef());
            }
            
            obj.getSelectQualifAttributes().marshallAttributes(domElement);
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no element content
        }        
    }

    /**
     * Internal class that supports OpenSAML xmltooling unmarshalling, placing values 
     * from the DOM into the local XMLObjects and their class variables
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            ResultQueryBaseType obj = (ResultQueryBaseType)xmlObject;

            if(!obj.getSelectQualifAttributes().processAttribute(attribute, obj))
            {
                String localName = attribute.getLocalName();
                if(localName.equals(ResultQueryBaseType.ATT_CHANGED_SINCE)) 
                {            
                    obj.setChangedSince(OpenLibertyHelpers.dateTimeForString(attribute.getValue()));
                }
                else if(localName.equals(ResultQueryBaseType.ATT_CONTINGENCY)) 
                {            
                    obj.setContingency(OpenLibertyHelpers.booleanFromString(attribute.getValue()));
                }
                else if(localName.equals(ResultQueryBaseType.ATT_INCLUDE_COMMON_ATTS)) 
                {            
                    obj.setIncludeCommonAttributes(OpenLibertyHelpers.booleanFromString(attribute.getValue()));
                }
                else if(localName.equals(ResultQueryBaseType.ATT_ITEM_ID)) 
                {            
                    obj.setItemID(attribute.getValue());
                }
                else if(localName.equals(ResultQueryBaseType.ATT_ITEM_ID_REF)) 
                {            
                    obj.setItemIDRef(attribute.getValue());
                }
            }
        }

        /**
         * ChangeFormat elements are placed first in changeFormat1 and then in changeFormat2, if changeFormat1 is not null, and
         * additional elements are stored changeFormat2, if there are more than 2, then the second one is overwritten
         */
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            ResultQueryBaseType obj = (ResultQueryBaseType)parentXMLObject;
            if(childXMLObject instanceof ChangeFormat)
            {
                if(obj.getChangeFormat1()==null)
                {
                    obj.setChangeFormat1((ChangeFormat)childXMLObject);
                }
                else
                {
                    obj.setChangeFormat2((ChangeFormat)childXMLObject);
                }
            }
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            // no element content
        }

    }


}

