package org.openliberty.xmltooling.dst2_1;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.AbstractXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * This class models the selectQualif xs:attributeGroup from the DST 2.1 XSD
 * 
 * @author asa
 *
 */
public class SelectQualifAttributes
{
    
    public static final String OBJECT_TYPE = "objectType";
    public static final String PREDEFINED = "predefined";
    
    
    private String objectType;  // xs:NCName. optional
    private String predefined;  // xs:string. optional
    
    
    /**
     * This is a convenience method used by any Marshaller that is marshalling 
     * an object that has SelectQualifAttributes
     *
     */
    public void marshallAttributes(Element domElement)
    {

        if(objectType!=null) 
        {
            domElement.setAttributeNS(null, OBJECT_TYPE, objectType);
        }

        if(predefined!=null)
        {
            domElement.setAttributeNS(null, PREDEFINED, predefined);
        }

    }

    /**
     * This method assists the unmarshaller, adding an XML Attribute to 
     * the SelectQualifAttributes object
     *     
     * @param attribute the attribute to set
     * 
     * @return whether an attribute was found and set
     */
    public boolean processAttribute(Attr attribute, AbstractXMLObject abstractXMLObject)
    {

        if (attribute.getLocalName().equals(OBJECT_TYPE)) 
        {            
            this.setObjectType(attribute.getValue(), abstractXMLObject);
        }
        else if (attribute.getLocalName().equals(PREDEFINED)) 
        {            
            this.setPredefined(attribute.getValue(), abstractXMLObject);
        }
        // Attribute Not Found
        else
        {
            return false;
        }

        // Attribute Found
        return true;

    }

    
    
    
    public void setObjectType(String objectType, AbstractXMLObject abstractXMLobject)
    {
        this.objectType = OpenLibertyHelpers.prepareForAssignment(this.objectType, objectType, abstractXMLobject);
    }
    
    public String getObjectType()
    {
        return objectType;
    }
    
    public void setPredefined(String predefined, AbstractXMLObject abstractXMLobject)
    {
        this.predefined = OpenLibertyHelpers.prepareForAssignment(this.predefined, predefined, abstractXMLobject);
    }
    
    public String getPredefined()
    {
        return predefined;
    }
    
    
}

/*
<xs:attribute name="objectType" type="xs:NCName"/>
<xs:attribute name="predefined" type="xs:string"/>

<xs:attributeGroup name="selectQualif">
  <xs:attribute ref="dst:objectType" use="optional"/>
  <xs:attribute ref="dst:predefined" use="optional"/>
</xs:attributeGroup>
*/