package org.openliberty.xmltooling.dst2_1;

import org.opensaml.core.xml.AbstractXMLObject;

/**
 * This class is the base type for TestItemType (urn:liberty:dst:2006-08:ref) which
 * is the type for TestItem
 *  
 * @author asa
 *
 */
public abstract class TestItemBaseType extends AbstractXMLObject
{

    public static final String ATT_ID = "id";
    public static final String ATT_ITEM_ID = "itemID";

    // Attributes
    private SelectQualifAttributes selectQualifAttributes;
    private String id;      // optional. xs:ID must be a valid NCName and unique in the document        
    private String itemID;  // optional. lu:itemID id that may not be scoped within the local xml instance document.

    protected TestItemBaseType(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        selectQualifAttributes = new SelectQualifAttributes();
    }

    public SelectQualifAttributes getSelectQualifAttributes()
    {
        return selectQualifAttributes;
    }

    /**
     * id must be a valid NCName and unique in the document    
     * 
     * @return xs:ID
     */
    public String getId()
    {
        return id;
    }

    public void setId(String id)
    {
        this.id = prepareForAssignment(this.id, id);
    }

    
    /**
     * The itemId attribute is an id that may not be scoped within the 
     * local xml instance document.
     * 
     * @return lu:itemID
     */
    public String getItemID()
    {
        return itemID;
    }

    public void setItemID(String itemID)
    {
        this.itemID = prepareForAssignment(this.itemID, itemID);
    }
    
}

/*
<xs:complexType name="TestItemBaseType">
  <xs:attributeGroup ref="dst:selectQualif"/>
  <xs:attribute name="id" use="optional" type="xs:ID"/>
  <xs:attribute ref="lu:itemID" use="optional"/>
</xs:complexType>




  <xs:attribute name="objectType" type="xs:NCName"/>
  <xs:attribute name="predefined" type="xs:string"/>

  <xs:attributeGroup name="selectQualif">
    <xs:attribute ref="dst:objectType" use="optional"/>
    <xs:attribute ref="dst:predefined" use="optional"/>
  </xs:attributeGroup>

 */