package org.openliberty.xmltooling.dst2_1;

import java.util.List;

import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;

/**
 * Indications of the outcomes of the test items that were present in the &lt;Query&gt;. 
 * 
 * @author asa
 *
 */
public class TestResult extends AbstractXMLObject
{
    
    public static final String LOCAL_NAME = "TestResult";

    public static final String ATT_ITEM_ID_REF = "itemIDRef";
    
    // Element Content
    private Boolean value;
    
    // Attribute
    private String itemIDRef;  // lu:itemIDRef
    
    protected TestResult(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public void setValue(Boolean value)
    {
        this.value = prepareForAssignment(this.value, value);
    }
    
    public Boolean getValue()
    {
        return this.value;
    }
    
    public void setItemIDRef(String itemIDRef)
    {
        this.itemIDRef = prepareForAssignment(this.itemIDRef, itemIDRef);
    }
    
    public String getItemIDRef()
    {
        return itemIDRef;
    }
        
    public List<XMLObject> getOrderedChildren()
    {
        return null;
    }

}
/*
<xs:element name="TestResult" type="dst:TestResultType"/>
<xs:complexType name="TestResultType">
  <xs:simpleContent>
    <xs:extension base="xs:boolean">
      <xs:attribute ref="lu:itemIDRef" use="required"/>
    </xs:extension>
  </xs:simpleContent>
</xs:complexType>
*/