package org.openliberty.xmltooling.dst2_1;

import net.shibboleth.utilities.java.support.xml.ElementSupport;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.w3c.dom.Element;


public class TestResultMarshaller extends AbstractXMLObjectMarshaller
{

    @Override
    protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
    {
        TestResult obj = (TestResult) xmlObject;
        
        if(obj.getItemIDRef() != null) 
        {
            domElement.setAttributeNS(null, TestResult.ATT_ITEM_ID_REF, obj.getItemIDRef());
        }
    }

    @Override
    protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
    {
        TestResult obj = (TestResult) xmlObject;
        ElementSupport.appendTextContent(domElement, OpenLibertyHelpers.stringFromBoolean(obj.getValue(), null));
    }

    
    
}
