package org.openliberty.xmltooling.dst2_1;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class TestResultUnmarshaller extends AbstractXMLObjectUnmarshaller
{

    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        TestResult obj = (TestResult) xmlObject;
        if (attribute.getLocalName().equals(TestResult.ATT_ITEM_ID_REF)) 
        {
            obj.setItemIDRef(attribute.getValue());
        }   
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {

    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        TestResult obj = (TestResult) xmlObject;
        obj.setValue(OpenLibertyHelpers.booleanFromString(elementContent));
    }


}
