package org.openliberty.xmltooling.dst2_1.ref;

import net.shibboleth.utilities.java.support.xml.ElementSupport;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.w3c.dom.Element;

public class DataMarshaller extends AbstractXMLObjectMarshaller
{

    @Override
    protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
    {
        Data obj = (Data)xmlObject;
        obj.getItemDataAttributes().marshallAttributes(domElement);
        obj.getPaginationResponseAttributes().marshallAttributes(domElement);
    }

    @Override
    protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
    {
        Data obj = (Data) xmlObject;
        ElementSupport.appendTextContent(domElement, obj.getValue());
    }

    
    
}
