package org.openliberty.xmltooling.dst2_1.ref;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.dst2_1.DataResponseBaseType;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

public abstract class DataResponseType extends DataResponseBaseType
{
    
    private XMLObjectChildrenList<ItemData> itemDatas;
    
    protected DataResponseType(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    public XMLObjectChildrenList<ItemData> getItemDatas()
    {
        if(null==itemDatas) itemDatas = new XMLObjectChildrenList<ItemData>(this);
        return itemDatas;
    }
    
    @Override
	public List<XMLObject> getOrderedChildren()
    {        
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        // Add the super kids
        children.addAll(super.getOrderedChildren()); 

        // now add the local kids
        if(null!=itemDatas) children.addAll(itemDatas); 
        
        return Collections.unmodifiableList(children);
    }

}

/*

<xs:complexType name="DataResponseType">
<xs:complexContent>
  <xs:extension base="dst:DataResponseBaseType">
    <xs:sequence>
      <xs:element ref="dstref:ItemData" minOccurs="0" maxOccurs="unbounded"/>
    </xs:sequence>
  </xs:extension>
</xs:complexContent>
</xs:complexType>

*/