package org.openliberty.xmltooling.dst2_1.ref;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class DataUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        Data obj = (Data) xmlObject;
        if(!obj.getItemDataAttributes().processAttribute(attribute, obj))
        {
            obj.getPaginationResponseAttributes().processAttribute(attribute, obj);
        }
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        /**
         *  This is not required or specified in the DST 2.1 reference schema, but 
         *  is used to store Elements that may be placed inside of the Data element
         *  by DST services such as Personal Profile
         *  
         */
        Data obj = (Data) parentXMLObject;
        obj.getUnknownXMLObjects().add(childXMLObject);        
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        Data obj = (Data) xmlObject;
        obj.setValue(elementContent);
    }

    
}
