package org.openliberty.xmltooling.dst2_1.ref;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class ItemDataUnmarshaller extends AbstractXMLObjectUnmarshaller
{
        
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        ItemData obj = (ItemData) xmlObject;
        obj.getItemDataAttributes().processAttribute(attribute, obj);
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        // no children
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        ItemData obj = (ItemData) xmlObject;
        obj.setValue(elementContent);
    }

    
}
