package org.openliberty.xmltooling.dst2_1.ref;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.dst2_1.RequestType;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

/**
 * The <Modify> element has two types of sub-elements. 
 * <li><ModifyItem> elements specify which data elements of the specified resource should be modified and how. </li>
 * <li><ResultQuery> elements can be included, when a WSC wants, for example, to get back data related to the
 * modifications it just made. </li>
 * 
 * @author asa
 *
 */
public class Modify extends RequestType
{
    
    public static final String LOCAL_NAME = "Modify";
    
    // Elements
    private XMLObjectChildrenList<ModifyItem> modifyItems;  // 1 is required
    private XMLObjectChildrenList<ResultQuery> resultQueries;
        
    public Modify(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        
        // at least 1 is required so initialize in the constructor
        modifyItems = new XMLObjectChildrenList<ModifyItem>(this);
    }

    public XMLObjectChildrenList<ModifyItem> getModifyItems()
    {
        return modifyItems;
    }
    
    public XMLObjectChildrenList<ResultQuery> getResultQueries()
    {
        if(null==resultQueries) resultQueries = new XMLObjectChildrenList<ResultQuery>(this);
        return resultQueries;
    }
    
    @Override
	public List<XMLObject> getOrderedChildren()
    {        
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        // Add the super kids
        children.addAll(super.getOrderedChildren()); 

        // now add the local kids
        if(null!=resultQueries) children.addAll(resultQueries); 
        if(null!=modifyItems) children.addAll(modifyItems);
        
        return Collections.unmodifiableList(children);
    }
    
    
    
}
/*

<xs:complexType name="ModifyType">
<xs:complexContent>
  <xs:extension base="dst:RequestType">
    <xs:sequence>
      <xs:element ref="dstref:ModifyItem"   minOccurs="1" maxOccurs="unbounded"/>
      <xs:element ref="dstref:ResultQuery"  minOccurs="0" maxOccurs="unbounded"/>
    </xs:sequence>
  </xs:extension>
</xs:complexContent>
</xs:complexType>

*/