package org.openliberty.xmltooling.dst2_1.ref;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.dst2_1.ModifyItemAttributeGroup;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;

/**
 * ModifyItem elements specify which data elements of the specified resource should be modified and how.
 * 
 * @author asa
 *
 */
public class ModifyItem extends AbstractXMLObject
{
    
    public static final String LOCAL_NAME = "ModifyItem";
    public static final String LOCAL_NAME_DST1_1 = "Modification";
    
    // Elements
    private Select select;
    private NewData newData;

    // Attributes
    private ModifyItemAttributeGroup modifyItemAttributes;
    
    /**
     * This was made public to enable a 
     * 
     * @param namespaceURI
     * @param elementLocalName
     * @param namespacePrefix
     */
    public ModifyItem(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        modifyItemAttributes = new ModifyItemAttributeGroup();
    }
    
    public void setSelect(Select select)
    {
        this.select = prepareForAssignment(this.select, select);
    }
    
    public Select getSelect()
    {
        return this.select;
    }

    public void setNewData(NewData newData)
    {
        this.newData = prepareForAssignment(this.newData, newData);
    }
    
    public NewData getNewData()
    {
        return this.newData;
    }
    
    public ModifyItemAttributeGroup getModifyItemAttributes()
    {
        return this.modifyItemAttributes;
    }
    
    public List<XMLObject> getOrderedChildren()
    {        
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        children.add(select);
        children.add(newData);
        
        return Collections.unmodifiableList(children);
    }
    
}

/*

<xs:element name="ModifyItem" type="dstref:ModifyItemType"/>
<xs:complexType name="ModifyItemType">
  <xs:sequence>
    <xs:element ref="dstref:Select"   minOccurs="0" maxOccurs="1"/>
    <xs:element ref="dstref:NewData"  minOccurs="0" maxOccurs="1"/>
  </xs:sequence>
  <xs:attributeGroup ref="dst:ModifyItemAttributeGroup"/>
</xs:complexType>

*/