package org.openliberty.xmltooling.dst2_1.ref;

import org.apache.log4j.Logger;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class ModifyItemUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    private static Logger log = Logger.getLogger(ModifyItemUnmarshaller.class);
       
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        ModifyItem obj = (ModifyItem) xmlObject;        
        obj.getModifyItemAttributes().processAttribute(attribute, obj);
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {  
        ModifyItem obj = (ModifyItem) parentXMLObject;  
        
        if(childXMLObject instanceof Select) obj.setSelect((Select) childXMLObject);
        else if(childXMLObject instanceof NewData) obj.setNewData((NewData) childXMLObject);
        else
        {
            log.error("The ModifyItem element does not allow for unknown child elements.");
        }
        
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {

    }

    
}
