package org.openliberty.xmltooling.dst2_1.ref;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.apache.log4j.Logger;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.dst2_1.DataResponseBaseType;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.openliberty.xmltooling.utility_2_0.ResponseType;
import org.openliberty.xmltooling.utility_2_0.Status;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class ModifyResponseUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    private static Logger log = Logger.getLogger(ModifyResponseUnmarshaller.class);

    
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        ModifyResponse obj = (ModifyResponse) xmlObject;
                
        if (attribute.getLocalName().equals(DataResponseBaseType.ATT_TIME_STAMP)) 
        {
            obj.setTimeStamp(OpenLibertyHelpers.dateTimeForString(attribute.getValue()));
        } 
        else if (attribute.getLocalName().equals(ResponseType.ATT_ITEM_ID_REF)) 
        {
            obj.setItemRefId(attribute.getValue());
        } 
        // xs:anyAttribute
        else 
        {
            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) 
            {
                obj.getUnknownAttributes().registerID(attribQName);
            }
            obj.getUnknownAttributes().put(attribQName, attribute.getValue());
        }     
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        
        ModifyResponse obj = (ModifyResponse) parentXMLObject;        
            
        if(childXMLObject instanceof ItemData) obj.getItemDatas().add((ItemData) childXMLObject);
        else if(childXMLObject instanceof Status) obj.setStatus((Status) childXMLObject);
        else if(childXMLObject instanceof Extension) obj.getExtensions().add((Extension) childXMLObject);
        else
        {
            log.error("The ModifyResponse element does not allow for unknown children.  Please use the Extensions elements to extend the object data definition.");
        }
        
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {

    }

    
}
