package org.openliberty.xmltooling.dst2_1.ref;


import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.apache.log4j.Logger;
import org.openliberty.xmltooling.dst2_1.RequestType;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class ModifyUnmarshaller extends AbstractXMLObjectUnmarshaller
{    
    private static Logger log = Logger.getLogger(ModifyUnmarshaller.class);
    
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        Modify obj = (Modify) xmlObject;
        
        if (attribute.getLocalName().equals(RequestType.ATT_ITEM_ID)) 
        {
            obj.setItemID(attribute.getValue());
        }   
        else
        {
            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) 
            {
                obj.getUnknownAttributes().registerID(attribQName);
            }
            obj.getUnknownAttributes().put(attribQName, attribute.getValue());
        }  
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        
        Modify obj = (Modify) parentXMLObject;      
        
        if(childXMLObject instanceof ModifyItem) obj.getModifyItems().add((ModifyItem) childXMLObject);
        else if(childXMLObject instanceof ResultQuery) obj.getResultQueries().add((ResultQuery) childXMLObject);
        else if(childXMLObject instanceof Extension) obj.getExtensions().add((Extension) childXMLObject);
        else
        {
            log.error("This element does not allow for unknown children.  Please use the Extensions element to extend the object data definition.");
        }

    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {        
    }

    
}
