package org.openliberty.xmltooling.dst2_1.ref;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.xml.namespace.QName;

import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;

public class NewData extends AppDataType implements ElementExtensibleXMLObject
{
    
    public static final String LOCAL_NAME = "NewData";
    
    private IndexedXMLObjectChildrenList<XMLObject> unknownObjects;
    
    public NewData(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        unknownObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);
    }
    /**
     * This is not part of the DST REF Specification but is added to support a more generic 
     * data return type, such as is required by the Personal Profile Service
     * 
     */
    public List<XMLObject> getUnknownXMLObjects()
    {
        return unknownObjects;
    }

    @SuppressWarnings("unchecked")
    public List<XMLObject> getUnknownXMLObjects(QName typeOrName)
    {
        return (List<XMLObject>) unknownObjects.subList(typeOrName);
    }
    
    /**
     * This is not needed by the Reference Implementation of the DST but is required
     * for users such as Personal Profile Service
     * 
     */
    @Override
	public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        if(null!=unknownObjects) children.addAll(unknownObjects);         
        return Collections.unmodifiableList(children);
    }
}
