package org.openliberty.xmltooling.dst2_1.ref;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.dst2_1.RequestType;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

/**
 * This class models the DST 2.1 Query Element
 * <p>
 * In the schema Query is based on QueryType, which is based on RequestType.  Since no other
 * elements in the ref are based on the QueryType, QueryType is implemented in the Query class.
 * 
 * @author asa
 *
 */ 
public class Query extends RequestType
{
    
    public static final String LOCAL_NAME = "Query";
    
    // Elements
    private XMLObjectChildrenList<TestItem> testItems;
    private XMLObjectChildrenList<QueryItem> queryItems;
    
    
    public Query(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    public XMLObjectChildrenList<TestItem> getTestItems()
    {
        if(null==testItems) testItems = new XMLObjectChildrenList<TestItem>(this);
        return testItems;
    }
  
    public XMLObjectChildrenList<QueryItem> getQueryItems()
    {
        if(null==queryItems) queryItems = new XMLObjectChildrenList<QueryItem>(this);
        return queryItems;
    }
    
    @Override
	public List<XMLObject> getOrderedChildren()
    {        
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        // Add the super kids
        children.addAll(super.getOrderedChildren()); 

        // now add the local kids
        if(null!=testItems) children.addAll(testItems); 
        if(null!=queryItems) children.addAll(queryItems);
        
        return Collections.unmodifiableList(children);
    }
    
    
}
