package org.openliberty.xmltooling.dst2_1.ref;

import org.openliberty.xmltooling.dst2_1.PaginationAttributeGroup;

/**
 * The QueryItem is an optional multi-occurance child element of Query that
 * specifies what data the requestor wants from the resource and how. There can be multiple 
 * &lt;QueryItem&gt; elements in one &lt;Query&gt;. Or there could be none: in this case the query  
 * is evaluated only for purposes of the test items. A &lt;QueryItem&gt; can be contingent on a 
 * &lt;TestItem&gt; by referencing the latter via an ID. Often the data set used to evaluate the test  
 * will also be helpful for the query, e.g., the test can prime the cache for the query. 
 * <p>
 * QueryItem is based on ResultQueryType
 * <p>
 * QueryItem is the only element based on the QueryItemType defined in the ref, and therefore the  
 * base Type was not created as a separate class
 * <p>
 * Example from a PP service:
 * <pre>
 * &lt;QueryItem itemID="name"&gt; 
 *     &lt;Select&gt;/pp:PP/pp:CommonName&lt;/Select&gt; 
 * &lt;/QueryItem&gt; 
 * </pre>
 * @author asa
 *
 */
public class QueryItem extends ResultQueryType
{    
    
    public static String LOCAL_NAME = "QueryItem";

    // Attributes
    private PaginationAttributeGroup paginationAttributes;

    public QueryItem(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        paginationAttributes = new PaginationAttributeGroup();
    }
 
    public PaginationAttributeGroup getPaginationAttributes()
    {
        return paginationAttributes;
    }

}
/*

<xs:element name="QueryItem" type="dstref:QueryItemType"/>
<xs:complexType name="QueryItemType">
  <xs:complexContent>
    <xs:extension base="dstref:ResultQueryType">
      <xs:attributeGroup ref="dst:PaginationAttributeGroup"/>
    </xs:extension>
  </xs:complexContent>
</xs:complexType>

*/