package org.openliberty.xmltooling.dst2_1.ref;

import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;

import org.openliberty.xmltooling.dst2_1.RequestType;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class QueryMarshaller extends AbstractXMLObjectMarshaller
{

    @Override
    protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
    {
        Query obj = (Query)xmlObject;

        if(obj.getItemID() != null) 
        {
            domElement.setAttributeNS(null, RequestType.ATT_ITEM_ID, obj.getItemID());
        }   
                
        // marshall the unknown attributes
        Attr attr;
        for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
        {
            attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
            attr.setValue(entry.getValue());
            domElement.setAttributeNodeNS(attr);
            if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
            {
                attr.getOwnerElement().setIdAttributeNode(attr, true);
            }
        }
    
    }

    @Override
    protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
    {
        // no element content to marshall
    }

    
    
}
