package org.openliberty.xmltooling.dst2_1.ref;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.dst2_1.DataResponseBaseType;
import org.openliberty.xmltooling.dst2_1.TestResult;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

/**
 * In addition to different identifiers the <QueryResponse> contains:
 * <ul>
 * <li><Status> Overall success or failure of the query </li>
 * <li><TestResult> (optional) Indications of the outcomes of the test items that were present in the <Query>. </li>
 * <li><Data> (optional) The data resulting from <QueryItem> elements. Each <Data> is correlated to corresponding <QueryItem> using itemIDRef XML attribute.</li>
 * </ul>
 * The <QueryResponse> elements are correlated, using their itemIDRef XML attributes, to the <Query> elements (ItemID XML attributes). 
 * <p>
 * @author asa
 *
 */
public class QueryResponse extends DataResponseBaseType
{

    public static final String LOCAL_NAME = "QueryResponse";
 
    // Elements
    private XMLObjectChildrenList<TestResult> testResults;
    private XMLObjectChildrenList<Data> datas;
    
    public QueryResponse(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    public XMLObjectChildrenList<TestResult> getTestResults()
    {
        if(null==testResults) testResults = new XMLObjectChildrenList<TestResult>(this);
        return testResults;
    }

    public XMLObjectChildrenList<Data> getDatas()
    {
        if(null==datas) datas = new XMLObjectChildrenList<Data>(this);
        return datas;
    }
    
    @Override
	public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        children.addAll( super.getOrderedChildren() );
        if(null!=testResults) children.addAll(testResults);
        if(null!=datas) children.addAll(datas);
        
        return Collections.unmodifiableList(children);
    }

}

/*

<xs:complexType name="QueryResponseType">
<xs:complexContent>
  <xs:extension base="dst:DataResponseBaseType">
    <xs:sequence>
      <xs:element ref="dst:TestResult"  minOccurs="0" maxOccurs="unbounded"/>
      <xs:element ref="dstref:Data" minOccurs="0" maxOccurs="unbounded"/>
    </xs:sequence>
  </xs:extension>
</xs:complexContent>
</xs:complexType>

*/