package org.openliberty.xmltooling.dst2_1.ref;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.apache.log4j.Logger;
import org.openliberty.xmltooling.dst2_1.RequestType;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class QueryUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    private static Logger log = Logger.getLogger(QueryUnmarshaller.class);   
    
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        Query obj = (Query) xmlObject;
        
        if (attribute.getLocalName().equals(RequestType.ATT_ITEM_ID)) 
        {
            obj.setItemID(attribute.getValue());
        }
        // xs:anyAttribute from RequestType
        else 
        {
            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) 
            {
                obj.getUnknownAttributes().registerID(attribQName);
            }
            obj.getUnknownAttributes().put(attribQName, attribute.getValue());
        }     
    }

    
    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        
        Query obj = (Query) parentXMLObject;        
        
        if(childXMLObject instanceof TestItem) obj.getTestItems().add((TestItem) childXMLObject);
        else if(childXMLObject instanceof QueryItem) obj.getQueryItems().add((QueryItem) childXMLObject);
        else if(childXMLObject instanceof Extension) obj.getExtensions().add((Extension) childXMLObject);
        else
        {
            log.error("The Query element does not allow for unknown children.  Please use the Extensions elements to extend the object data definition.");
        }
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        
    }

    
}
