package org.openliberty.xmltooling.dst2_1.ref;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.dst2_1.ResultQueryBaseType;
import org.opensaml.core.xml.XMLObject;

/**
 * Extended by QueryItem and ResultQuery
 * 
 * @author asa
 *
 */
public abstract class ResultQueryType extends ResultQueryBaseType
{
    // Elements
    private Sort sort;
    private Select select;
    
    protected ResultQueryType(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    // Elements 
    public Select getSelect()
    {
        return select;
    }

    public void setSelect(Select select)
    {
        this.select = select;
    }
 
    public Sort getSort()
    {
        return sort;
    }

    public void setSort(Sort sort)
    {
        this.sort = sort;
    }
    
    
    @Override
	public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        children.addAll(super.getOrderedChildren()); 
        children.add(select);
        children.add(sort);
        return Collections.unmodifiableList(children);
    }
    
    /*
    public static final String ATT_ITEM_ID_REF = "itemIDRef";
    public static final String ATT_CONTINGENCY = "contingency";
    public static final String ATT_INCLUDE_COMMON_ATTS = "includeCommonAttributes";
    public static final String ATT_CHANGED_SINCE = "changedSince";
    public static final String ATT_ITEM_ID = "itemID";
    
    // Attributes 
    private SelectQualifAttributes selectQualifAttributes;
    private String itemIDRef;
    private Boolean contingency;
    private Boolean includeCommonAttributes;
    private DateTime changedSince;
    private String itemID;
    

    
    protected ResultQueryType(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        selectQualifAttributes = new SelectQualifAttributes();
    }
    
    

    // Attributes
    
    public DateTime getChangedSince()
    {
        return changedSince;
    }

    public Boolean getContingency()
    {
        return contingency;
    }

    public Boolean getIncludeCommonAttributes()
    {
        return includeCommonAttributes;
    }

    public String getItemID()
    {
        return itemID;
    }

    public String getItemIDRef()
    {
        return itemIDRef;
    }

    public SelectQualifAttributes getSelectQualifAttributes()
    {
        return selectQualifAttributes;
    }

    public void setChangedSince(DateTime changedSince)
    {
        this.changedSince = changedSince;        
    }

    public void setContingency(Boolean contingency)
    {
        this.contingency = contingency;
    }

    public void setIncludeCommonAttributes(Boolean includeCommonAttributes)
    {
        this.includeCommonAttributes = includeCommonAttributes;
    }

    public void setItemID(String itemID)
    {
        this.itemID = itemID;        
    }

    public void setItemIDRef(String itemIDRef)
    {
        this.itemIDRef = itemIDRef;                
    }

    
    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        if(null!=changeFormats) children.addAll(changeFormats); 
        children.add(select);
        children.add(sort);
        return Collections.unmodifiableList(children);
    }
    */
    
}



/*
<xs:element name="ResultQuery" type="dstref:ResultQueryType"/>
<xs:complexType name="ResultQueryType">
  <xs:complexContent>
    <xs:extension base="dst:ResultQueryBaseType">
      <xs:sequence>
        <xs:element ref="dstref:Select"   minOccurs="0" maxOccurs="1"/>
        <xs:element name="Sort"   minOccurs="0" maxOccurs="1" type="dstref:SortType"/>
      </xs:sequence>
    </xs:extension>
  </xs:complexContent>
</xs:complexType>
*/