
package org.openliberty.xmltooling.dst2_1.ref;

import java.util.List;

import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;

/**
 * The <Sort> element contains the criteria according to which the data in the response 
 * should be sorted. For example, address cards of a contact book could be sorted based on names using either ascending 
 * or descending order. As sorting is resource consuming the service specification MUST use sorting very carefully and 
 * specify sorting only based on the data and criteria which are really needed. In many cases sorting on the server side 
 * is not needed at all. When sorting is needed, only a very limited set of available sorting criteria should be defined.
 * <p>
 * 
 * @author asa
 *
 */
public class Sort extends AbstractXMLObject
{

    public static final String LOCAL_NAME = "Sort";
    
    private String value;
    
    protected Sort(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getValue()
    {
        return this.value;
    }

    public void setValue(String value)
    {
        this.value = value;
    }
    
    public List<XMLObject> getOrderedChildren()
    {
        return null;
    }
    
    
}

/*
  <xs:complexType name="SortType">
    <xs:simpleContent>
      <xs:extension base="xs:string"/>
    </xs:simpleContent>
  </xs:complexType>

*/