package org.openliberty.xmltooling.dst2_1.ref;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.dst2_1.TestItemBaseType;
import org.opensaml.core.xml.XMLObject;

/**
 * The &lt;TestItem> contains a &lt;TestOp> qualified by some attributes. The two, in conjunction with objectType are used to indicate 
 * <ol>
 * <li> the data on which the test is to be performed </li>
 * <li> the reference data against which the data (1) is to be tested </li>
 * <li> the nature of the test. </li>
 * </ol>
 * 
 * The content of the &lt;TestOp&gt;, the TestOpType, MUST be specified by the service specification that references DST. 
 * For example, if service specification specifies XPath as query language and WSC wanted to ask whether or not the 
 * principal is of age, it could do so as follows: 
 * <pre>
 * &lt;TestItem objectType="profile"&gt; 
 *     &lt;TestOp&gt;//Age >= '21'&lt;/TestOp&gt; 
 * &lt;/TestItem&gt; 
 * </pre>
 * In the above example, all 3 aspects of the test are expressed within the XPath expression that appears in &lt;TestOp&gt;. 
 * Each &lt;TestItem&gt; evaluates to true or false depending on result of evaluation of the &lt;TestOp&gt;. 
 * <p>
 * 
 * @author asa
 *
 */
public class TestItem extends TestItemBaseType
{

    public static String LOCAL_NAME = "TestItem";
    
    // Elements
    private TestOp testOp;
    
    protected TestItem(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public TestOp getTestOp()
    {
        return testOp;
    }
    
    public void setTestOp(TestOp testOp)
    {
        this.testOp = testOp;
    }
    
    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        children.add(testOp); 
        return Collections.unmodifiableList(children);
    }

    
    
    
}

/*
<xs:element name="TestItem" type="dstref:TestItemType"/>
<xs:complexType name="TestItemType">
  <xs:complexContent>
    <xs:extension base="dst:TestItemBaseType">
      <xs:sequence>
        <xs:element name="TestOp"   minOccurs="0" maxOccurs="1" type="dstref:TestOpType"/>
      </xs:sequence>
    </xs:extension>
  </xs:complexContent>
</xs:complexType>
*/