package org.openliberty.xmltooling.dst2_1.ref;

import org.openliberty.xmltooling.dst2_1.TestItemBaseType;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.w3c.dom.Element;

public class TestItemMarshaller extends AbstractXMLObjectMarshaller
{

    @Override
    protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
    {
        TestItem obj = (TestItem)xmlObject;
        
        // Marshall SelectQualifAttributes first
        obj.getSelectQualifAttributes().marshallAttributes(domElement);

        if(obj.getId() != null) 
        {
            domElement.setAttributeNS(null, TestItemBaseType.ATT_ID, obj.getId());
        } 
        
        if(obj.getItemID() != null) 
        {
            domElement.setAttributeNS(null, TestItemBaseType.ATT_ITEM_ID, obj.getItemID());
        } 
        
    }

    @Override
    protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
    {
        // no element content
    }

    
    
}
