package org.openliberty.xmltooling.dst2_1.ref;

import org.apache.log4j.Logger;
import org.openliberty.xmltooling.dst2_1.TestItemBaseType;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class TestItemUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    private static Logger log = Logger.getLogger(TestItemUnmarshaller.class);
        
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        TestItem obj = (TestItem) xmlObject; 
        
        if (attribute.getLocalName().equals(TestItemBaseType.ATT_ID)) 
        {
            obj.setId(attribute.getValue());
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        }
        else if (attribute.getLocalName().equals(TestItemBaseType.ATT_ITEM_ID)) 
        {
            obj.setItemID(attribute.getValue());
        } 
        
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        TestItem obj = (TestItem) parentXMLObject;        
        
        if(childXMLObject instanceof TestOp) obj.setTestOp((TestOp) childXMLObject);
        else
        {
            log.error("The TestItem element does not allow for unknown child elements.");
        }
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        
    }

    
}
