package org.openliberty.xmltooling.dst2_1.ref;

import java.util.List;

import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;

/**
 * The TestOp class represents an element containing a test operation that evaluates
 * to true or false.  TestOp resides inside of TestItem.  The following is an example
 * of a TestOp that uses an XPath expression:
 * 
 * <pre>
 * &lt;TestOp&gt;//Age >= �21�&lt;/TestOp&gt; 
 * </pre>
 * 
 * @author asa
 *
 */
public class TestOp extends AbstractXMLObject
{

    public static String LOCAL_NAME = "TestOp";

    private String value;
    
    protected TestOp(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public void setValue(String value) 
    {
        this.value = prepareForAssignment(this.value, value);
    }

    public String getValue() 
    { 
        return value; 
    }
    
    public List<XMLObject> getOrderedChildren()
    {
        // no children
        return null;
    }

}
/*
 
<xs:complexType name="TestOpType">
<xs:simpleContent>
  <xs:extension base="xs:string"/>
</xs:simpleContent>
</xs:complexType>
*/
