package org.openliberty.xmltooling.idsis.dap;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * The AppDataType carries either an {@link LDIF} or a {@link DAPSubscription}
 * element, not both.
 * 
 * &lt;xs:complexType name="AppDataType"&gt;
 * &lt;xs:choice&gt;
 *   &lt;xs:element ref="dap:LDIF"/&gt;
 *   &lt;xs:element ref="dap:Subscription"/&gt;
 * &lt;/xs:choice&gt;
 * &lt;/xs:complexType&gt;
 * 
 * @author asa
 *
 */
public abstract class AppDataType extends AbstractSignableXMLObject
{
    
    // Elements
    private LDIF ldif;
    private DAPSubscription subscription;
    
    protected AppDataType(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
        
    public LDIF getLDIF()
    {
        return ldif;
    }

    /**
     * If the ldif parameter is not null, then this method
     * will set the subscription to null before setting
     * the LDIF element
     * 
     * @param ldif
     */
    public void setLDIF(LDIF ldif)
    {
        if(null!=ldif) setSubscription(null);
        this.ldif = prepareForAssignment(this.ldif, ldif);
    }

    public DAPSubscription getSubscription()
    {
        return subscription;
    }

    /**
     * If the subscription parameter is not null then this 
     * method sets the ldif object to null before setting
     * the subscription.
     * 
     * @param subscription
     */
    public void setSubscription(DAPSubscription subscription)
    {
        if(null!=subscription) setLDIF(null);
        this.subscription = prepareForAssignment(this.subscription, subscription);
    }
    
    /**
     * In the case of AppDataType, only one of the child elements
     * may be set and therefore returned in the OrderedChildren 
     * List.
     * 
     */
    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        // only one child allowed
        if(null!=ldif) children.add(ldif); 
        else if(null!=subscription) children.add(subscription); 
        
        return Collections.unmodifiableList(children);
    }

    
    /**
     * Internal Marshaller - unused
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no attributes            
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no ele content
        }
        
    }
    
    
    
    /**
     * Internal class that handles unmarshalling the object from the DOM
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {       
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {            
            AppDataType obj = (AppDataType) parentXMLObject;

            if(childXMLObject instanceof LDIF)
            {
                obj.setLDIF((LDIF)childXMLObject);                   
            }
            else if(childXMLObject instanceof DAPSubscription)
            {
                obj.setSubscription((DAPSubscription)childXMLObject);                   
            }
        }

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            // no attributes
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            // no ele content
        }
    }
    
}
