package org.openliberty.xmltooling.idsis.dap;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.CreateItemAttributeGroup;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * ID-SIS-DAP DAPCreateItem maps straight to the LDAP Add operation. The LDIF format data in the {@link LDIF} container
 * in the NewData container will specify the distinguished names of the new entries.
 * <p>
 * <pre>
 * &lt;xs:complexType name="CreateItemType"&gt;
 * &lt;xs:sequence&gt;
 *   &lt;xs:element ref="dap:NewData" minOccurs="0" maxOccurs="1"/&gt;
 * &lt;/xs:sequence&gt;
 * &lt;xs:attributeGroup ref="dst:CreateItemAttributeGroup"/&gt;
 * &lt;/xs:complexType&gt;
 * </pre>
 * 
 * @author asa
 *
 */
public class DAPCreateItem extends AbstractSignableXMLObject
{    
    public static String LOCAL_NAME = "CreateItem";

    // Attributes
    private CreateItemAttributeGroup createItemAttributeGroup;  // FROM DST

    // Element
    private DAPNewData newData;

    public DAPCreateItem()
    {
        super(Konstantz.DAP_NS, LOCAL_NAME, Konstantz.DAP_PREFIX);
        createItemAttributeGroup = new CreateItemAttributeGroup();
    }

    protected DAPCreateItem(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        createItemAttributeGroup = new CreateItemAttributeGroup();
    }
    
    // Attributes
    public CreateItemAttributeGroup getCreateItemAttributeGroup()
    {
        return createItemAttributeGroup;        
    }

    // Elements
    public void setNewData(DAPNewData newData)
    {
        this.newData = prepareForAssignment(this.newData, newData);
    }

    public DAPNewData getNewData()
    {
        return this.newData;
    }
    
    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        if(null!=newData) children.add(newData); 

        return Collections.unmodifiableList(children);        
    }


    
    
    /**
     * Internal class that handles unmarshalling the object from the DOM
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {       
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {            
            DAPCreateItem obj = (DAPCreateItem) parentXMLObject;

            if(childXMLObject instanceof DAPNewData)
            {
                obj.setNewData((DAPNewData)childXMLObject);                   
            }
        }

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            DAPCreateItem obj = (DAPCreateItem)xmlObject;
            obj.getCreateItemAttributeGroup().processAttribute(attribute, obj);       
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            // no element content            
        }
    }


    /**
     * Internal class that handles marshalling the object to the DOM
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            DAPCreateItem obj = (DAPCreateItem)xmlObject;
            obj.getCreateItemAttributeGroup().marshallAttributes(domElement);
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            // no element content
        }   
    }



    /**
     * Internal class for the builder to simplify the class structure
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DAPCreateItem> 
    {
                
        @Override
		public DAPCreateItem buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new DAPCreateItem(namespaceURI, localName, namespacePrefix);
        }

    }


}
