package org.openliberty.xmltooling.idsis.dap;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.RequestType;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

/**
 * <pre>
 *   &lt;xs:complexType name="DeleteType"&gt;
 *     &lt;xs:complexContent&gt;
 *       &lt;xs:extension base="dst:RequestType"&gt;
 *         &lt;xs:sequence&gt;
 *           &lt;xs:element ref="dap:DeleteItem"    minOccurs="1" maxOccurs="unbounded"/&gt;
 *         &lt;/xs:sequence&gt;
 *       &lt;/xs:extension&gt;
 *     &lt;/xs:complexContent&gt;
 *   &lt;/xs:complexType&gt;
 *   </pre>
 * @author asa
 *
 */
public class DAPDelete extends RequestType
{

    public static String LOCAL_NAME = "Delete";
    
    // Elements
    private XMLObjectChildrenList<DAPDeleteItem> deleteItems;
    
    /**
     * This constructor is provided since it is required by the 
     * specification that each Delete element contain at least 1 DeleteItem,
     * therefore, this is a convenience method 
     * 
     * @param modifyItem
     */
    public DAPDelete(DAPDeleteItem deleteItem)
    {
        super(Konstantz.DAP_NS, LOCAL_NAME, Konstantz.DAP_PREFIX);
        
        deleteItems = new XMLObjectChildrenList<DAPDeleteItem>(this);
        deleteItems.add(deleteItem);        
    }
    
    protected DAPDelete(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        deleteItems = new XMLObjectChildrenList<DAPDeleteItem>(this);
    }

    
    public XMLObjectChildrenList<DAPDeleteItem> getDAPDeleteItems()
    {
        return deleteItems;
    }

    
    @Override
	public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();        
        
        // add super kids
        children.addAll(super.getOrderedChildren());
        
        // add the local kids
        children.addAll(deleteItems); 

        return Collections.unmodifiableList(children);
    }
    


    /**
     * Marshall attributes into the DOM
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestType.Marshaller
    { 
    }
    
    
    /**
     * Internal class that handles unmarshalling from the DOM
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestType.Unmarshaller
    {       
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {            
            DAPDelete obj = (DAPDelete) parentXMLObject;
            if(childXMLObject instanceof DAPDeleteItem)
            {
                obj.getDAPDeleteItems().add((DAPDeleteItem)childXMLObject);                   
            }
            else 
            {
                super.processChildElement(parentXMLObject, childXMLObject);
            }
        }
    }
    
    
    /**
     * Internal class for the builder to simplify the class structure
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DAPDelete> 
    {
        @Override
		public DAPDelete buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new DAPDelete(namespaceURI, localName, namespacePrefix);
        }
    }

    
    
    
    
    
}
