package org.openliberty.xmltooling.idsis.dap;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.DeleteItemBaseType;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;


/**
 * 
 * <pre>
 *   &lt;xs:element name="DeleteItem" type="dap:DeleteItemType"/&gt;
 *   &lt;xs:complexType name="DeleteItemType"&gt;
 *     &lt;xs:complexContent&gt;
 *       &lt;xs:extension base="dst:DeleteItemBaseType"&gt;
 *         &lt;xs:sequence&gt;
 *           &lt;xs:element ref="dap:Select"    minOccurs="0" maxOccurs="1"/&gt;
 *         &lt;/xs:sequence&gt;
 *       &lt;/xs:extension&gt;
 *     &lt;/xs:complexContent&gt;
 *   &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class DAPDeleteItem  extends DeleteItemBaseType
{
    
    public static String LOCAL_NAME = "DeleteItem";
    
    // Elements 
    private DAPSelect select;

    protected DAPDeleteItem()
    {
        super(Konstantz.DAP_NS, LOCAL_NAME, Konstantz.DAP_PREFIX);
    }

    protected DAPDeleteItem(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    public void setDAPSelect(DAPSelect select)
    {
        this.select = prepareForAssignment(this.select, select);
    }
    
    /**
     * If &lt;Select&gt; is used &lt;DeleteItem&gt; relating to 
     * objectType "entry," &lt;Filter&gt; element MUST NOT be 
     * specified and NONE of the XML attributes MUST be specified. 
     * 
     * @return
     */
    public DAPSelect getDAPSelect()
    {
        return select;
    }
    
    
    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();        
        if(null!=select) children.add(select); 
        return Collections.unmodifiableList(children);
    }

    
    /**
     * Internal marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends DeleteItemBaseType.Marshaller
    {        
    }
    
    /** 
     * Internal Unmarshaller unmarshalling the DOM into java objects
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends DeleteItemBaseType.Unmarshaller
    {
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            DAPDeleteItem obj = (DAPDeleteItem)parentXMLObject;
            if(childXMLObject instanceof DAPSelect)
            {
                obj.setDAPSelect((DAPSelect)childXMLObject);
            }
        }
    }
    
    
    /**
     * Internal builder 
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DAPDeleteItem>
    {
        @Override
        public DAPDeleteItem buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new DAPDeleteItem(namespaceURI, localName, namespacePrefix);
        }
    }
    
    
    
}
