package org.openliberty.xmltooling.idsis.dap;

import org.openliberty.xmltooling.dst2_1.ItemDataAttributeGroup;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 *  <pre> 
 *  &lt;xs:element name="ItemData" type="dap:ItemDataType"/&gt;
 *   &lt;xs:complexType name="ItemDataType"&gt;
 *     &lt;xs:complexContent&gt;
 *       &lt;xs:extension base="dap:AppDataType"&gt;
 *         &lt;xs:attributeGroup ref="dst:ItemDataAttributeGroup"/&gt;
 *       &lt;/xs:extension&gt;
 *     &lt;/xs:complexContent&gt;
 *   &lt;/xs:complexType&gt;
 *   </pre>
 * @author asa
 *
 */
public class DAPItemData extends AppDataType
{
    
    public static String LOCAL_NAME = "DAPItemData";    
    
    private ItemDataAttributeGroup itemDataAttributeGroup;
    
    protected DAPItemData(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        itemDataAttributeGroup = new ItemDataAttributeGroup();
    }

    public ItemDataAttributeGroup getItemDataAttributeGroup()
    {
        return itemDataAttributeGroup;
    }
    
    
    /**
     * Marshall from xmltooling classes to the DOM
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AppDataType.Marshaller
    {
        /**
         * Marshall the attributes into a DOM element. 
         */
         @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
             DAPItemData obj = (DAPItemData)xmlObject;
             obj.getItemDataAttributeGroup().marshallAttributes(domElement);
        }
    }
    
    
    /**
     * Unmarshall from DOM
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AppDataType.Unmarshaller
    {
        /**
         * There are no attributes in the AppDataType, but dap.ItemData
         * contains the {@link ItemDataAttributeGroup}
         */
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            DAPItemData obj = (DAPItemData)xmlObject;
            obj.getItemDataAttributeGroup().processAttribute(attribute, obj);
        }
    }
    
    
    /**
     * Internal Builder Class
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DAPItemData>
    {
        @Override
        public DAPItemData buildObject(String namespaceURI, String localName, String namespacePrefix)
        {            
            return new DAPItemData(namespaceURI, localName, namespacePrefix);
        }
        
    }
    
}
