package org.openliberty.xmltooling.idsis.dap;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.RequestType;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;


/**
 * <pre>
 *   &lt;xs:complexType name="ModifyType"&gt;
 *     &lt;xs:complexContent&gt;
 *       &lt;xs:extension base="dst:RequestType"&gt;
 *         &lt;xs:sequence&gt;
 *           &lt;xs:element ref="dap:Subscription"  minOccurs="0" maxOccurs="unbounded"/&gt;
 *           &lt;xs:element ref="dap:ModifyItem"    minOccurs="1" maxOccurs="unbounded"/&gt;
 *           &lt;xs:element ref="dap:ResultQuery"   minOccurs="0" maxOccurs="unbounded"/&gt;
 *         &lt;/xs:sequence&gt;
 *       &lt;/xs:extension&gt;
 *     &lt;/xs:complexContent&gt;
 *   &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class DAPModify extends RequestType
{
    public static String LOCAL_NAME = "Modify";

    // Elements 
    private XMLObjectChildrenList<DAPSubscription> subscriptions;
    private XMLObjectChildrenList<DAPModifyItem> modifyItems;
    private XMLObjectChildrenList<DAPResultQuery> resultQueries;    
    
    /**
     * This constructor is provided since it is required by the 
     * spec that each Modify element contain at least 1 ModifyItem,
     * therefore, this is a convenience method 
     * 
     * @param modifyItem
     */
    public DAPModify(DAPModifyItem modifyItem)
    {
        super(Konstantz.DAP_NS, LOCAL_NAME, Konstantz.DAP_PREFIX);        
        modifyItems = new XMLObjectChildrenList<DAPModifyItem>(this);
        modifyItems.add(modifyItem);        
    }
    
    /**
     * Takes an LDIF String and creates a ModifyItem that contains a NewData
     * element with an LDIF element containing that String.  Then adds the
     * ModifyItem to this {@link DAPModify}
     * 
     * @param ldifString
     */
    public DAPModify(String ldifString)
    {
        super(Konstantz.DAP_NS, LOCAL_NAME, Konstantz.DAP_PREFIX);  
                
        modifyItems = new XMLObjectChildrenList<DAPModifyItem>(this);
        
        LDIF ldif = new LDIF();
        ldif.setValue(ldifString);
        
        DAPNewData newData = new DAPNewData();
        newData.setLDIF(ldif);
        
        DAPModifyItem modifyItem = new DAPModifyItem();
        modifyItem.setDAPNewData(newData);
        
        modifyItems.add(modifyItem);  
    }
    
    
    protected DAPModify(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        modifyItems = new XMLObjectChildrenList<DAPModifyItem>(this);
    }

    public XMLObjectChildrenList<DAPSubscription> getDAPSubscriptions()
    {
        if(null==subscriptions) subscriptions = new XMLObjectChildrenList<DAPSubscription>(this);
        return subscriptions;
    }

    public XMLObjectChildrenList<DAPModifyItem> getDAPModifyItems()
    {
        return modifyItems;
    }

    public XMLObjectChildrenList<DAPResultQuery> getDAPResultQueries()
    {
        if(null==resultQueries) resultQueries = new XMLObjectChildrenList<DAPResultQuery>(this);
        return resultQueries;
    }

    @Override
	public List<XMLObject> getOrderedChildren()
    {        
        List<XMLObject> children = new LinkedList<XMLObject>();

        // Add the super kids
        children.addAll(super.getOrderedChildren()); 

        // now add the local kids
        if(null!=subscriptions) children.addAll(subscriptions); 
        if(null!=modifyItems) children.addAll(modifyItems); 
        if(null!=resultQueries) children.addAll(resultQueries); 
        
        return Collections.unmodifiableList(children);
    }
    
    

    /**
     * Marshall attributes into the DOM
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestType.Marshaller
    { 
    }
    
    /**
     * Internal class that handles unmarshalling from the DOM
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestType.Unmarshaller
    {       
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {            
            DAPModify obj = (DAPModify) parentXMLObject;

            if(childXMLObject instanceof DAPResultQuery)
            {
                obj.getDAPResultQueries().add((DAPResultQuery)childXMLObject);                   
            }
            else if(childXMLObject instanceof DAPModifyItem)
            {
                obj.getDAPModifyItems().add((DAPModifyItem)childXMLObject);                   
            }
            else if(childXMLObject instanceof DAPSubscription)
            {
                obj.getDAPSubscriptions().add((DAPSubscription)childXMLObject);                   
            }
            else 
            {
                super.processChildElement(parentXMLObject, childXMLObject);
            }
        }
    }
    
    
    
    
    /**
     * Internal class for the builder to simplify the class structure
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DAPModify> 
    {
        @Override
		public DAPModify buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new DAPModify(namespaceURI, localName, namespacePrefix);
        }
    }

    
    
    
}
