package org.openliberty.xmltooling.idsis.dap;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.ModifyItemAttributeGroup;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * 
 * 
 * <pre>
 *   &lt;xs:element name="ModifyItem" type="dap:ModifyItemType"/&gt;
 *   &lt;xs:complexType name="ModifyItemType"&gt;
 *     &lt;xs:sequence&gt;
 *       &lt;xs:element ref="dap:Select"    minOccurs="0" maxOccurs="1"/&gt;
 *       &lt;xs:element ref="dap:NewData"   minOccurs="0" maxOccurs="1"/&gt;
 *     &lt;/xs:sequence&gt;
 *     &lt;xs:attributeGroup ref="dst:ModifyItemAttributeGroup"/&gt;
 *   &lt;/xs:complexType&gt;
 *   </pre>
 * 
 * @author asa
 *
 */
public class DAPModifyItem extends AbstractSignableXMLObject
{
    
    public static String LOCAL_NAME = "ModifyItem";

    // Attributes 
    private ModifyItemAttributeGroup modifyItemAttributeGroup;
    
    // Elements 
    private DAPSelect select;
    private DAPNewData newData;
    
    protected DAPModifyItem()
    {
        super(Konstantz.DAP_NS, LOCAL_NAME, Konstantz.DAP_PREFIX);
        modifyItemAttributeGroup = new ModifyItemAttributeGroup();
    }

    protected DAPModifyItem(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        modifyItemAttributeGroup = new ModifyItemAttributeGroup();
    }

    public ModifyItemAttributeGroup getModifyItemAttributeGroup()
    {
        return modifyItemAttributeGroup;
    }
    
    public void setDAPSelect(DAPSelect select)
    {
        this.select = prepareForAssignment(this.select, select);
    }
    
    /**
     * If &lt;Select&gt; is used &lt;ModifyItem&gt; relating to 
     * objectType "entry," &lt;Filter&gt; element MUST NOT be 
     * specified and NONE of the XML attributes MUST be specified. 
     * 
     * @return
     */
    public DAPSelect getDAPSelect()
    {
        return select;
    }
    
    public void setDAPNewData(DAPNewData newData)
    {
        this.newData = prepareForAssignment(this.newData, newData);
    }
    
    public DAPNewData getDAPNewData()
    {
        return newData;
    }
    
    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        if(null!=select) children.add(select); 
        if(null!=newData) children.add(newData); 
        
        return Collections.unmodifiableList(children);
    }

    
    /**
     * Internal marshaller placing values into the DOM
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            DAPModifyItem obj = (DAPModifyItem)xmlObject;
            obj.getModifyItemAttributeGroup().marshallAttributes(domElement);        
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no element content
        }
        
    }
    
    /** 
     * Internal Unmarshaller unmarshalling the DOM into java objects
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            DAPModifyItem obj = (DAPModifyItem)xmlObject;
            obj.getModifyItemAttributeGroup().processAttribute(attribute, obj);
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            DAPModifyItem obj = (DAPModifyItem)parentXMLObject;
            if(childXMLObject instanceof DAPSelect)
            {
                obj.setDAPSelect((DAPSelect)childXMLObject);
            }
            else if(childXMLObject instanceof DAPNewData)
            {
                obj.setDAPNewData((DAPNewData)childXMLObject);
            }

        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            // no element content
        }
        
    }
    
    
    
    /**
     * Internal builder 
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DAPModifyItem>
    {
        @Override
        public DAPModifyItem buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new DAPModifyItem(namespaceURI, localName, namespacePrefix);
        }
    }
    
    
    
}
