package org.openliberty.xmltooling.idsis.dap;

import java.util.List;

import org.openliberty.xmltooling.utility_2_0.Status;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.soap.soap11.Body;

/**
 *   <pre>
 *   &lt;xs:complexType name="ModifyResponseType"&gt;
 *     &lt;xs:complexContent&gt;
 *       &lt;xs:extension base="dap:DataResponseType"/&gt;
 *     &lt;/xs:complexContent&gt;
 *   &lt;/xs:complexType&gt;
 *   </pre>
 * 
 * @author asa
 *
 */
public class DAPModifyResponse extends DataResponseType
{

    public static String LOCAL_NAME = "ModifyResponse";

    protected DAPModifyResponse(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    /**
     * Looks into the Status element to see whether the result was
     * successful
     * 
     * @return
     */
    public boolean isSuccess()
    {
        Status status = getStatus();
        if(null!=status) return status.isOK();
        else return false;
    }

    /**
     * Convenience method to extract a CreateResponse from
     * the body of a SOAP message.  
     * 
     * @param body
     * @return a {@link DAPCreateResponse} or null if there is none in the body
     */
    public static DAPModifyResponse extractFromBody(Body body)
    {
        if(null!=body)
        {
            List<XMLObject> children = body.getUnknownXMLObjects();
            if(null!=children)
            {

                for(XMLObject child : children)
                {
                    if(child instanceof DAPCreateResponse)
                    {
                        return (DAPModifyResponse)child;
                    }
                }
            }
        }
        return null;
    }


    /**
     * Internal Builder class for DAPModifyResponse
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DAPModifyResponse>
    {
        @Override
        public DAPModifyResponse buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new DAPModifyResponse(namespaceURI, localName, namespacePrefix);
        }
    }


}
