package org.openliberty.xmltooling.idsis.dap;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.schema.impl.XSAnyMarshaller;

/**
 * NewData is used inside of {@link DAPCreateItem} and
 * inside of {@link DAPModifyItem} as the container for 
 * LDIF or Subscription information.
 *<p>
 * builder: {@link DAPNewData.Builder} <br/>
 * unmarshaller: {@link AppDataType.Unmarshaller}<br/>
 * marshaller: {@link XSAnyMarshaller}
 * </p>
 * 
 * @author asa
 *
 */
public class DAPNewData extends AppDataType
{
    public static String LOCAL_NAME = "NewData";
    
    public DAPNewData()
    {
        super(Konstantz.DAP_NS, LOCAL_NAME, Konstantz.DAP_PREFIX);
    }
    
    protected DAPNewData(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    
    /**
     * Internal class for the builder to simplify the class structure
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DAPNewData> 
    {    
        @Override
		public DAPNewData buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new DAPNewData(namespaceURI, localName, namespacePrefix);
        }
    }
    
    
}
