package org.openliberty.xmltooling.idsis.dap;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.subs.NotificationType;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

/**
 * Notification
 * 
 * <pre>
 *   &lt;xs:element name="Notification" type="dap:NotificationType"/&gt;
 *   &lt;xs:complexType name="NotificationType"&gt;
 *     &lt;xs:complexContent&gt;
 *       &lt;xs:extension base="subs:NotificationType"&gt;
 *         &lt;xs:sequence&gt;
 *           &lt;xs:element ref="dap:ItemData"  minOccurs="0" maxOccurs="unbounded"/&gt;
 *         &lt;/xs:sequence&gt;
 *       &lt;/xs:extension&gt;
 *     &lt;/xs:complexContent&gt;
 *   &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class DAPNotification extends NotificationType
{
    
    public static String LOCAL_NAME = "Notification";
    
    // Elements
    private XMLObjectChildrenList<DAPItemData> itemDatas;
    
    protected DAPNotification(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    public XMLObjectChildrenList<DAPItemData> getDAPItemDatas()
    {
        if(null==itemDatas) itemDatas = new XMLObjectChildrenList<DAPItemData>(this);
        return itemDatas;
    }

    @Override
	public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        // Add super kids
        children.addAll(super.getOrderedChildren());
        
        // Add local kids
        if(null!=itemDatas) children.addAll(itemDatas); 

        return Collections.unmodifiableList(children);
    }
    

    /**
     * Internal marshalling class
     * 
     * @author asa
     *
     */
    public static class Marshaller extends NotificationType.Marshaller
    {        
    }
    
    /**
     * Internal unmarshaling class
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends NotificationType.Unmarshaller
    {
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            DAPNotification obj = (DAPNotification) parentXMLObject;
            
            if(childXMLObject instanceof DAPItemData)
            {
                obj.getDAPItemDatas().add((DAPItemData)childXMLObject);
            }
            else
            {
                super.processChildElement(parentXMLObject, childXMLObject);
            }
        }
    }

    
    /**
     * Internal builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DAPNotification>
    {
        @Override
        public DAPNotification buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new DAPNotification(namespaceURI, localName, namespacePrefix);
        }        
    }
    
    
}
