package org.openliberty.xmltooling.idsis.dap;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.joda.time.DateTime;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.dst2_1.RequestType;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * 
 * <pre>
 *   &lt;xs:complexType name="NotifyType"&gt;
 *     &lt;xs:complexContent&gt;
 *       &lt;xs:extension base="dst:RequestType"&gt;
 *         &lt;xs:sequence&gt;
 *           &lt;xs:element ref="dap:Notification"  minOccurs="0" maxOccurs="unbounded"/&gt;
 *         &lt;/xs:sequence&gt;
 *         &lt;xs:attributeGroup ref="subs:NotifyAttributeGroup"/&gt;
 *       &lt;/xs:extension&gt;
 *     &lt;/xs:complexContent&gt;
 *   &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class DAPNotify extends RequestType
{
    public static String LOCAL_NAME = "Notify";

    // Attributes (NotifyAttributeGroup)
    private DateTime timeStamp;

    // Attribute Names
    public static String ATT_TIME_STAMP = "timeStamp";

    // Elements
    private XMLObjectChildrenList<DAPNotification> notifications;


    protected DAPNotify(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public DateTime getTimeStamp()
    {
        return timeStamp;
    }

    public void setTimeStamp(DateTime timeStamp)
    {
        this.timeStamp = prepareForAssignment(this.timeStamp, timeStamp);
    }

    public XMLObjectChildrenList<DAPNotification> getDAPNotifications()
    {
        if(null==notifications) notifications = new XMLObjectChildrenList<DAPNotification>(this);
        return notifications;
    }

    @Override
	public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        // super kids
        children.addAll(super.getOrderedChildren());

        // local kids
        if(null!=notifications) children.addAll(notifications); 

        return Collections.unmodifiableList(children);
    }
    
    
    /**
     * Internal Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestType.Marshaller
    {
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            DAPNotify obj = (DAPNotify)xmlObject;
            
            if(obj.getTimeStamp() != null) 
            {
                domElement.setAttributeNS(null, DAPNotify.ATT_TIME_STAMP, OpenLibertyHelpers.stringForDateTime(obj.getTimeStamp()));
            } 
            
            super.marshallAttributes(xmlObject, domElement);
        }
    }
    

    /**
     * Internal Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestType.Unmarshaller
    {
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            DAPNotify obj = (DAPNotify)xmlObject;

            if (attribute.getLocalName().equals(DAPNotify.ATT_TIME_STAMP)) 
            {
                obj.setTimeStamp(OpenLibertyHelpers.dateTimeForString( attribute.getValue() ));
            } 
            else
            {
                super.processAttribute(xmlObject, attribute);
            }
        }        
        
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            DAPNotify obj = (DAPNotify) parentXMLObject;

            if(childXMLObject instanceof DAPNotification)
            {
                obj.getDAPNotifications().add((DAPNotification)childXMLObject);                   
            }
            else
            {
                super.processChildElement(parentXMLObject, childXMLObject);
            }
        }
    }

    /**
     * Internal builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DAPNotify>
    {
        @Override
        public DAPNotify buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new DAPNotify(namespaceURI, localName, namespacePrefix);
        }        
    }

}
