package org.openliberty.xmltooling.idsis.dap;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.PaginationAttributeGroup;
import org.openliberty.xmltooling.subs.Subscription;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * Differs from the DST 2.1 ref implementation of QueryItem only in that 
 * the Select element is dap specific, requiring {@link DAPSelect}.  This 
 * class and builder is provided to make the construction of a QueryItem
 * more straightforward. 
 * <pre>
 * &lt;xs:element name="QueryItem" type="dap:QueryItemType"/&gt;
 * &lt;xs:complexType name="QueryItemType"&gt;
 *   &lt;xs:complexContent&gt;
 *     &lt;xs:extension base="dap:ResultQueryType"&gt;
 *       &lt;xs:attributeGroup ref="dst:PaginationAttributeGroup"/&gt;
 *     &lt;/xs:extension&gt;
 *   &lt;/xs:complexContent&gt;
 * &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class DAPQueryItem extends DAPResultQuery
{
    
    public static String LOCAL_NAME = "QueryItem";
    
    // Attributes
    private PaginationAttributeGroup paginationAttributeGroup;
    
    public DAPQueryItem()
    {
        super(Konstantz.DAP_NS, LOCAL_NAME, Konstantz.DAP_PREFIX);
    }

    public DAPQueryItem(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
        
    public void setObjectType(ObjectType objectType)
    {
        super.getSelectQualifAttributes().setObjectType(objectType.value, this);
    }

    public ObjectType getObjectType()
    {
        return ObjectType.objectTypeForValue( super.getSelectQualifAttributes().getObjectType() );
    }

    public PaginationAttributeGroup getPaginationAttributeGroup()
    {
        if(null==paginationAttributeGroup) paginationAttributeGroup = new PaginationAttributeGroup();
        return paginationAttributeGroup;
    }

    
    public static class Unmarshaller extends DAPResultQuery.Unmarshaller
    {
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            DAPQueryItem obj = (DAPQueryItem)xmlObject;  
            if(!obj.getPaginationAttributeGroup().processAttribute(attribute, obj))
            {
                super.processAttribute(xmlObject, attribute);
            }
        }
    }
    
    
    public static class Marshaller extends DAPResultQuery.Marshaller
    {
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            DAPQueryItem obj = (DAPQueryItem)xmlObject;            
            obj.getPaginationAttributeGroup().marshallAttributes(domElement);
            super.marshallAttributes(xmlObject, domElement);
        }
    }
    
    
    /**
     * Internal class for the builder to simplify the class structure
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DAPQueryItem> 
    {
        @Override
		public DAPQueryItem buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new DAPQueryItem(namespaceURI, localName, namespacePrefix);
        }
    }
    

    /**
     * This enum enumerates the ObjectTypes supported by ID-SIS-DAP
     * 
     * @author asa
     *
     */
    public enum ObjectType
    {        
        /**
         * Object named by distinguished name, often referred to as dn and containing a directory 
         * entry as defined in [RFC2251]. 
         */
        ENTRY("entry"), 
        
        /**
         * A {@link Subscription} object, as defined in [LibertySUBS]. Furthermore the subscriptions themselves 
         * should follow the semantics of [LDAPPSearch]. 
         */
        SUBSCRIPTION("_Subscription");
        
        String value;
        ObjectType(String value)
        {
            this.value = value;
        }

        public static ObjectType objectTypeForValue(String value)
        {
            if(null!=value)
            {
                for(ObjectType objectType : values())
                {
                    if(objectType.value.equals(value)) return objectType;
                }
            }
            return null;
        }
    }


}
